#include "application.h"
#include <iostream>
using namespace std;
#include "consoleutil.h"
#include <conio.h>

Vector2 screenMin(0,0), screenMax(SCREEN_WIDTH-1,SCREEN_HEIGHT-1);

void clearScreen()
{
	Rect screen(screenMin, screenMax);
	screen.draw(' ');
}

void makeRandomTri(Tri & t)
{
	t.a = Vector2::random(screenMin, screenMax);
	t.b = Vector2::random(screenMin, screenMax);
	t.c = Vector2::random(screenMin, screenMax);
}

void makeRandomRect(Rect * r)
{
	Vector2 randomv = Vector2::random(screenMin, screenMax);
	r->min = randomv;
	r->max = randomv;
	randomv = Vector2::random(screenMin, screenMax);
	r->add(randomv);
}

void Application::init()
{
	for(int i = 0; i < NUM_RECT; ++i)
	{
		rectangles[i] = new Rect;
		makeRandomRect(rectangles[i]);
	}
	for(int i = 0; i < NUM_TRI; ++i)
	{
		triangles[i] = new Tri;
		makeRandomTri(*triangles[i]);
	}
	selectedIndex = 0;
	selected = rectangles[0];
	selectedType = Application::TYPE_RECT;
	state = Application::STATE_RUNNING;

	cout << "'<' and '>' to select shapes" << endl
	     << "'w', 'a', 's', 'd' to move the selected shape" << endl
	     << "'space' to randomize current shape" << endl
		 << endl << "press any key to begin the program" << endl;
	_getch();
	clearScreen();
}

void Application::release()
{
	for(int i = 0; i < NUM_RECT; ++i)
	{
		delete rectangles[i];
	}
	for(int i = 0; i < NUM_TRI; ++i)
	{
		delete triangles[i];
	}
}

void Application::draw()
{
	// draw all shapes
	for(int i = 0; i < NUM_RECT; ++i)
	{
		rectangles[i]->draw('a'+i);
	}
	for(int i = 0; i < NUM_TRI; ++i)
	{
		triangles[i]->draw(NUM_RECT+'a'+i);
	}

	// draw the selected shape
	switch(selectedType)
	{
	case TYPE_RECT:
		((Rect*)selected)->draw('#');
		break;
	case TYPE_TRI:
		((Tri*)selected)->draw('#');
		break;
	}
	
	// draw extra info at the bottom
	moveCursor(0, 0);
	cout << "shape[" << selectedIndex << "], a ";
	const char * shapeName;
	if(selectedType == TYPE_RECT)
	{
		shapeName = "rectangle  ";
	}
	else
	{
		shapeName = "triangle   ";
	}
	cout << shapeName << endl;
}

void Application::setUserInput(int input)
{
	userKeyPress = input;
}

void Application::update()
{
	bool changedSelection = false;
	bool shapeMoving = false;
	switch(userKeyPress)
	{
	case 27:
		state = Application::STATE_QUIT;
		break;
	case ',':
	case '<':
		selectedIndex--;
		changedSelection = true;
		break;
	case '.':
	case '>':
		selectedIndex++;
		changedSelection = true;
		break;
	case 'w':
	case 'a':
	case 's':
	case 'd':
	case ' ':
		shapeMoving = true;
		break;
	}

	if(shapeMoving)
	{
		switch(selectedType)
		{
		case TYPE_RECT:
			((Rect*)selected)->draw(' ');
			break;
		case TYPE_TRI:
			((Tri*)selected)->draw(' ');
			break;
		}
		switch(userKeyPress)
		{
		case 'w':
			switch(selectedType)
			{
			case TYPE_RECT:
				((Rect*)selected)->translate(Vector2(0,-1));
				break;
			case TYPE_TRI:
				((Tri*)selected)->translate(Vector2(0,-1));
				break;
			}
			break;
		case 'a':
			switch(selectedType)
			{
			case TYPE_RECT:
				((Rect*)selected)->translate(Vector2(-1,0));
				break;
			case TYPE_TRI:
				((Tri*)selected)->translate(Vector2(-1,0));
				break;
			}
			break;
		case 's':
			switch(selectedType)
			{
			case TYPE_RECT:
				((Rect*)selected)->translate(Vector2(0,+1));
				break;
			case TYPE_TRI:
				((Tri*)selected)->translate(Vector2(0,+1));
				break;
			}
			break;
		case 'd':
			switch(selectedType)
			{
			case TYPE_RECT:
				((Rect*)selected)->translate(Vector2(+1,0));
				break;
			case TYPE_TRI:
				((Tri*)selected)->translate(Vector2(+1,0));
				break;
			}
			break;
		case ' ':
			switch(selectedType)
			{
			case TYPE_RECT:
				makeRandomRect( (Rect*)selected );
				break;
			case TYPE_TRI:
				makeRandomTri( *((Tri*)selected) );
				break;
			}
			break;
		}
	}
	userKeyPress = 0;

	if(changedSelection)
	{
		int TOTAL_NUMBER_OF_SHAPES = NUM_RECT + NUM_TRI;
		if(selectedIndex < 0)
		{
			selectedIndex = TOTAL_NUMBER_OF_SHAPES-1;
		}
		else if (selectedIndex >= TOTAL_NUMBER_OF_SHAPES)
		{
			selectedIndex = 0;
		}

		if(selectedIndex >= 0 && selectedIndex < NUM_RECT)
		{
			selectedType = TYPE_RECT;
			selected = rectangles[selectedIndex];
		}
		else if(selectedIndex >= NUM_RECT && selectedIndex < NUM_RECT+NUM_TRI)
		{
			selectedType = TYPE_TRI;
			selected = triangles[selectedIndex - NUM_RECT];
		}
		if(selectedIndex < 0 || selectedIndex >= TOTAL_NUMBER_OF_SHAPES)
		{
			selected = 0;
			selectedType = -1;
		}
	}
}
